//  LauncherOSX
//
//  Created by Boris Schneiderman.
//  Copyright (c) 2012-2013 The Readium Foundation.
//
//  The Readium SDK is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

//This is demo file that does nothing
//Host application has to override this file and provide it's own logic for handling ReadiumSDK events
//See LauncherOSX and LauncherIOS for examples
ReadiumSDK.HostAppFeedback = function() {

    ReadiumSDK.on(ReadiumSDK.Events.READER_INITIALIZED, function(){
        window.navigator.epubReadingSystem.name = AdobeRDMHelper.epubReadingSystem_name;
        window.navigator.epubReadingSystem.version = AdobeRDMHelper.epubReadingSystem_version;

        ReadiumSDK.reader.on(ReadiumSDK.Events.PAGINATION_CHANGED, this.onPaginationChanged, this);
        ReadiumSDK.reader.on(ReadiumSDK.Events.SETTINGS_APPLIED, this.onSettingsApplied, this);
        ReadiumSDK.reader.on(ReadiumSDK.Events.CONTENT_DOCUMENT_LOADED, this.onContentLoaded, this);
        ReadiumSDK.reader.on(ReadiumSDK.Events.MEDIA_OVERLAY_STATUS_CHANGED, this.onMediaOverlayStatusChanged, this);
        ReadiumSDK.reader.on(ReadiumSDK.Events.MEDIA_OVERLAY_TTS_SPEAK, this.onMediaOverlayTTSSpeak, this);
        ReadiumSDK.reader.on(ReadiumSDK.Events.MEDIA_OVERLAY_TTS_STOP, this.onMediaOverlayTTSStop, this);
		ReadiumSDK.reader.on(ReadiumSDK.Events.EXTERNAL_LINK_CLICKED, this.onExternalLinkClicked, this);
        ReadiumSDK.reader.on(ReadiumSDK.Events.GENERIC_HOST_CALLBACK, this.onGenericHostCallback, this);

        external.onReaderInitialized();

    }, this);


    this.onPaginationChanged = function(paginationInfo) {
        if (external) {
            external.onPaginationChanged(JSON.stringify(paginationInfo.paginationInfo));
        }

    };

    this.onSettingsApplied = function() {
        if (external)
		{
            external.onSettingsApplied();
        }

    };

    this.onContentLoaded = function() {
        if (external)
		{
            external.onContentLoaded();
        }
    };


    this.onMediaOverlayStatusChanged = function(status) {
		if(external)
		{
            external.onMediaOverlayStatusChanged(JSON.stringify(status));
        }
    };

    this.onMediaOverlayTTSSpeak = function(tts) {
		if(external)
		{
            external.onMediaOverlayTTSSpeak(JSON.stringify(tts));
        }

    };

    this.onMediaOverlayTTSStop = function() {
        if (external)
		{
            external.onMediaOverlayTTSStop();
        }

    };

	    //USE_ADOBE_DRM
    this.onExternalLinkClicked = function(msg) {
        {
            external.onExternalLinkClicked(msg);
	 }
    };

    //USE_ADOBE_DRM
    this.onGenericHostCallback = function(msg) {
        
        if(external) {
            external.onGenericHostCallback(JSON.stringify(msg));
        }
    };    

}();

